/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorLevitateModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> LEVITATE = TConstruct.createKey((String)"heavy");

    public ArmorLevitateModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, ArmorLevitateModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(LEVITATE, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(LEVITATE, (Object)0);
            if (level > 0 && attacker instanceof LivingEntity) {
                LivingEntity attackerl = (LivingEntity)attacker;
                if (event.getAmount() != 0.0f && RANDOM.nextFloat() <= (float)level * 0.4f) {
                    attackerl.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, level - 1));
                }
            }
        });
    }
}

